unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, InstCtrl, XPMan, Spin, AppEvnts;

type
  TForm1 = class(TForm)
    Button1: TButton;
    RadioGroup1: TRadioGroup;
    OneInstance1: TOneInstance;
    OpenDialog1: TOpenDialog;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure OneInstance1NewInstanceLoad(NewAppHandle: Cardinal;
      NewCommandLineW: PWideChar);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  i: Byte;
  s: string;
begin
  OneInstance1.MaxNewInstances := SpinEdit1.Value;

  case RadioGroup1.ItemIndex of
    0: begin
      for i := 0 to (Random(10) + 1) do
        s := s + ' ' + Chr(Random(27) + 65);
    end;
    1: begin
      with OpenDialog1 do
        if Execute then
        begin
          Files.Delimiter := ' ';
          s := Files.DelimitedText;
        end;
    end;
  end;

  WinExec(PChar(Application.ExeName + ' ' + s), SW_NORMAL);
end;

procedure TForm1.OneInstance1NewInstanceLoad(NewAppHandle: Cardinal;
  NewCommandLineW: PWideChar);
const
  BreakLine = #13#10;
var
  i, c: Integer;
  s: WideString;
begin
  c := WParamCount(NewCommandLineW);
  for i := 1 to (c - 1) do
    s := WideFormat('%s%s%s', [s, BreakLine, WParamStr(NewCommandLineW, i)]);
    
  MessageBoxW(Handle,
    PWideChar(WideFormat('NewInstanceLoad with %.2d parameter(s):%s%s',
        [c - 1, BreakLine, s])),
    'Information',
    MB_OK or MB_ICONINFORMATION);
end;

end.
