
//Test the component, please setup BMP associate to this PROJECT1.EXE

unit Unit1;

interface

uses
  Classes, Controls, Dialogs, ExtCtrls, Forms, Menus, MainInstance,
  Messages, SysUtils, Windows;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    MainInstance1: TMainInstance;
    procedure FormCreate(Sender: TObject);
    procedure Open1Click(Sender: TObject);
  private
    { Private declarations }
    procedure NeedFileOpen(var Msg: tMessage); message wmMainInstanceOpenFile;
    procedure LoadFile(aFileName: String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var S: String;
procedure GetParams;
var i: Integer;
begin
  S:= '';
  for i:= 1 to ParamCount do
  begin
    S:= S+ ParamStr(i)+ ' ';
    if Pos('.EXE', UpperCase(S))<>0 then S:= '';  //ParamCount uncorrect if
  end;                                            //there is space char in the path
end;
begin
  if ParamCount> 0 then
  begin
    GetParams;
    while S[Length(S)]= ' ' do Delete(S, Length(S), 1);
    if S<> '' then LoadFile(S);
  end;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then LoadFile(OpenDialog1.FileName);
end;

{private}

procedure TForm1.NeedFileOpen(var Msg: tMessage);
var S: String;
    PC: array[0..MAX_PATH]of Char;
begin
  GlobalGetAtomName(Msg.wParam, PC, MAX_PATH);
  S:= StrPas(PC);                                     //sorry need adjust string
  while S[Length(S)]= ' ' do Delete(S, Length(S), 1); //for Picture.LoadFromFile
  LoadFile(S);
end;

procedure TForm1.LoadFile(aFileName: String);
begin
  Image1.Picture.LoadFromFile(aFileName);
end;

end.
